#!/bin/bash

if [ "$1" != "start" ]
then
        exit 0;
fi

. /etc/exorint.funcs
. /etc/default/rcS

FACTORYTMPMNT="/mnt/factory"
SSL_DIR="${FACTORYTMPMNT}/etc/ssl"
SSL_DIR_SYM="/etc/ssl"

CERT="${SSL_DIR}/certs/ssl-cert-os.pem"
CSR="${SSL_DIR}/certs/ssl-cert-os.csr"
KEY="${SSL_DIR}/private/ssl-cert-os.key"

CA_CERTS="${SSL_DIR}/certs/ca-certificates.crt"
CA_CERTS_OS="/usr/share/ssl/ca-certificates.crt"

getHexFromDtb() {
    dtc_data=$( dtc -I dtb -O dts "$1" | grep "$2" | sed 's:^.*<\(.*\)>;:\1:' | sed 's:0x:000000:g' )
    data="0x"
    for i in $dtc_data; do
        data="${data}${i:${#i}-8:8}"
    done

    echo $data
}


if [ ! -f "${CERT}" ] || [ ! -f "${KEY}" ] || [ ! -f "${CSR}" ]; then
   echo "Generating SSL keypair..."

   mount -o remount,rw ${FACTORYTMPMNT}

   rm -rf "${SSL_DIR}" "${SSL_DIR_SYM}"
   mkdir -p "$( dirname $CERT )" "$( dirname $KEY )"

   HOSTNAME="$(hostname)"
   SUBJECT="/CN=${HOSTNAME}"

   SSL_CONFIG="/tmp/openssl.cnf"
   printf "distinguished_name = req_dn\n[req_dn]\n" >> "${SSL_CONFIG}"
   printf "[SAN]\nsubjectAltName=DNS:${HOSTNAME},DNS:${HOSTNAME}.local\n" >> "${SSL_CONFIG}"
   openssl req -x509 -nodes -days 36500 -newkey rsa:2048 -sha512 \
      -subj "${SUBJECT}" \
      -config "${SSL_CONFIG}" \
      -extensions SAN \
      -keyout "${KEY}" -out "${CERT}"
   rm "${SSL_CONFIG}"

   openssl req -new -key "${KEY}" -sha512 -out "${CSR}" -subj "${SUBJECT}"

   # TODO BSP-5636 Keypair is currently used by nginx but also by applications. We should generate
   # separate keypairs for different use cases and store them in the keychain with proper access control
   chown root:app "${KEY}" "${CERT}" "${CSR}"
   chmod 640 "${KEY}"
   chmod 644 "${CERT}" "${CSR}"

   mount -o remount,ro ${FACTORYTMPMNT}
fi

if [ ! -L "${CA_CERTS}" ]; then
   mount -o remount,rw ${FACTORYTMPMNT}
   mkdir -p "$( dirname ${CA_CERTS} )"
   ln -sf ${CA_CERTS_OS} ${CA_CERTS}
   mount -o remount,ro ${FACTORYTMPMNT}
fi

if [ ! -L "${SSL_DIR_SYM}" ]; then
   rm -rf "${SSL_DIR_SYM}"
   ln -s "${SSL_DIR}" "${SSL_DIR_SYM}"
fi

# BSP-5636 Check permissions in case files have been generated by older BSP versions
if [ "$(stat -c "%G" ${KEY})" != "app" ]; then
   mount -o remount,rw ${FACTORYTMPMNT}
   chown root:app "${KEY}" "${CERT}" "${CSR}"
   chmod 640 "${KEY}"
   chmod 644 "${CERT}" "${CSR}"
   mount -o remount,ro ${FACTORYTMPMNT}
fi

if [ "$SECURE_BOOT" = "yes" ]; then
	# Extract the platform public key so that it's readly available to applications
	TMP_DIR=/tmp/.platform-key
	KEY_DIR=/usr/share/platform-keys

	mkdir $TMP_DIR
	chmod 700 $TMP_DIR

	if ( exorint_in_mainos ); then
		platform_itb=/mnt/fit-mainos/key-platform.itb
	else
		platform_itb=/mnt/fit-configos/key-platform.itb
	fi

	if [ -f "$platform_itb" ]; then
		dumpimage -T flat_dt -p 0 -o $TMP_DIR/platform.dtb $platform_itb
	else
		# Use master key as platform key
		case $(exorint_hwcode) in

		# ETOP7XX|ETOP7XXQ
		115|118)
			# Get bootloader image
			dd if=/dev/mmcblk1 of=$TMP_DIR/uboot.img bs=1024 count=1024 skip=1

			# Extract dtb
			dtbOffset="$( fdtdump -s $TMP_DIR/uboot.img 2>/dev/null | sed -n 's:.*found fdt at offset \(0x[a-z0-9]\+\):\1:p' )"
			dtbSize="$( fdtdump -s $TMP_DIR/uboot.img 2>/dev/null | sed -n 's:.*totalsize\:.*\(0x[a-z0-9]\+\).*:\1:p' )"
			dd if=$TMP_DIR/uboot.img of=$TMP_DIR/platform.dtb bs=1 skip=$(( $dtbOffset )) count=$(( $dtbSize ))
		;;

		# ETOP7XXM|EX205|X7/X10
		145|154|155)
			# Get bootloader image
			dd if=/dev/mmcblk1 of=$TMP_DIR/uboot.img bs=1024 count=1024 skip=33

			# Extract itb
			itbOffset="$( fdtdump -s $TMP_DIR/uboot.img 2>/dev/null | sed -n 's:.*found fdt at offset \(0x[a-z0-9]\+\):\1:p' )"
			dd if=$TMP_DIR/uboot.img of=$TMP_DIR/uboot.itb bs=1 skip=$(( $itbOffset )) &>/dev/null

			# Get dtb size and offset and extract
			dtbPart=$( fdtdump $TMP_DIR/uboot.itb 2>/dev/null | sed -n '/fdt@/,/};/{/fdt@/b;/};/b;p}' )
			dtbPartSize=$( echo $dtbPart | sed -n 's:.*data-size = <\([0-9a-z]\+\)>;.*:\1:p' )
			dtbPartPos=$( echo $dtbPart | sed -n 's:.*data-position = <\([0-9a-z]\+\)>;.*:\1:p' )
			dd of=$TMP_DIR/platform.dtb if=$TMP_DIR/uboot.itb bs=1 count=$(( $dtbPartSize )) skip=$(( $dtbPartPos ))
		;;
		esac

	fi

	key_modulus="$( getHexFromDtb $TMP_DIR/platform.dtb "rsa,modulus" )"
	key_exponent="$( getHexFromDtb $TMP_DIR/platform.dtb "rsa,exponent" )"

	cat << EOF > $TMP_DIR/platform.asn1
asn1=SEQUENCE:pubkeyinfo
[pubkeyinfo]
algorithm=SEQUENCE:rsa_alg
pubkey=BITWRAP,SEQUENCE:rsapubkey
[rsa_alg]
algorithm=OID:rsaEncryption
parameter=NULL
[rsapubkey]
n=INTEGER:$key_modulus
e=INTEGER:$key_exponent
EOF

	openssl asn1parse -genconf $TMP_DIR/platform.asn1 -out $TMP_DIR/platform.der -noout
	openssl rsa -in $TMP_DIR/platform.der -inform der -pubin -out $TMP_DIR/platform.pem

	mount -t tmpfs -o size=8K none $KEY_DIR
	cp $TMP_DIR/platform.pem $KEY_DIR
	chmod 622 $KEY_DIR
	mount -o remount,ro $KEY_DIR
	rm -rf $TMP_DIR
fi
